/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.handler.data.INpcRecipe;
import noppes.npcs.api.wrapper.WrapperRecipe;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiEditIngredients;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class GuiNPCManageRecipes
extends GuiContainerNPCInterface2
implements ICustomScrollListener,
ISubGuiListener {
    private static boolean onlyMod = true;
    private static final WrapperRecipe recipe = new WrapperRecipe();
    private static final int green = new Color(-9375632).getRGB();
    private static final int red = new Color(-1019792).getRGB();
    private final Map<Boolean, Map<String, List<WrapperRecipe>>> data = new TreeMap<Boolean, Map<String, List<WrapperRecipe>>>();
    private GuiCustomScroll groups;
    private GuiCustomScroll recipes;
    private boolean wait = false;

    public GuiNPCManageRecipes(EntityNPCInterface npc, ContainerManageRecipes container) {
        super(npc, (Container)container);
        this.drawDefaultBackground = false;
        this.setBackground("inventorymenu.png");
        GuiNPCManageRecipes.recipe.domen = "customnpcs";
        this.field_147000_g = 200;
    }

    @Override
    public void buttonEvent(@Nonnull IGuiNpcButton button, int mouseButton) {
        ItemStack heldStack;
        if (mouseButton == 1) {
            int id = button.getID();
            ItemStack heldStack2 = this.player.field_71071_by.func_70445_o();
            if (id >= 10 && id < 27) {
                if (id == 10) {
                    if (heldStack2.func_190926_b()) {
                        GuiNPCManageRecipes.recipe.product.func_190920_e(Math.max(1, GuiNPCManageRecipes.recipe.product.func_190916_E() - 1));
                    } else if (GuiNPCManageRecipes.recipe.product.func_190926_b()) {
                        ItemStack stack = null;
                        if (GuiNPCManageRecipes.recipe.main) {
                            stack = heldStack2.func_77946_l();
                        } else {
                            for (WrapperRecipe wr : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                                if (!wr.main) continue;
                                stack = wr.product.func_77946_l();
                                break;
                            }
                        }
                        if (stack != null) {
                            stack.func_190920_e(1);
                            GuiNPCManageRecipes.recipe.product = stack;
                        }
                    } else if (!GuiNPCManageRecipes.recipe.main || NoppesUtilPlayer.compareItems(GuiNPCManageRecipes.recipe.product, heldStack2, false, false)) {
                        GuiNPCManageRecipes.recipe.product.func_190920_e(Math.min(GuiNPCManageRecipes.recipe.product.func_77976_d(), GuiNPCManageRecipes.recipe.product.func_190916_E() + 1));
                    }
                    if (GuiNPCManageRecipes.recipe.product.func_190926_b()) {
                        button.setLayerColor(red);
                    }
                } else {
                    int pos = id - 11;
                    ItemStack[] array = GuiNPCManageRecipes.recipe.recipeItems.get(pos);
                    if (heldStack2.func_190926_b() && array != null && array.length > 0) {
                        int p = button.getCurrentStackID();
                        int count = Math.max(0, array[p].func_190916_E() - 1);
                        if (count > 0) {
                            array[p].func_190920_e(count);
                        } else {
                            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                            for (int i = 0; i < array.length; ++i) {
                                if (i == p) continue;
                                list.add(array[i]);
                            }
                            array = list.toArray(new ItemStack[0]);
                        }
                        button.setStacks(array);
                        button.setCurrentStackPos(p);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    } else if (!(array != null && array.length != 0 || heldStack2.func_190926_b())) {
                        ItemStack stack = heldStack2.func_77946_l();
                        stack.func_190920_e(1);
                        array = new ItemStack[]{stack};
                        button.setStacks(array);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    } else if (array != null) {
                        for (int i = 0; i < array.length; ++i) {
                            if (array[i].func_190926_b() || !NoppesUtilPlayer.compareItems(array[i], heldStack2, false, false)) continue;
                            array[i].func_190920_e(Math.min(array[i].func_77976_d(), array[i].func_190916_E() + 1));
                            button.setStacks(array);
                            button.setCurrentStackPos(i);
                            GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                            break;
                        }
                    }
                    if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                        button.setLayerColor(recipe.isValid() ? (array != null && array.length > 0 ? 0 : green) : red);
                    }
                }
            }
        }
        if (mouseButton == 2 && (heldStack = this.player.field_71071_by.func_70445_o()).func_190926_b()) {
            ItemStack stack = button.getCurrentStack().func_77946_l();
            stack.func_190920_e(stack.func_77976_d());
            this.player.field_71071_by.func_70437_b(stack);
            Client.sendData(EnumPacketServer.SetItem, stack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        int id = button.getID();
        if (id >= 10 && id < 27) {
            if (!GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                return;
            }
            if (id != 10 && GuiNPCManageRecipes.func_146272_n()) {
                if (GuiNPCManageRecipes.recipe.recipeItems.get(id - 11).length > 0) {
                    this.setSubGui(new SubGuiEditIngredients(id - 11, GuiNPCManageRecipes.recipe.recipeItems.get(id - 11)));
                }
                return;
            }
            ItemStack heldStack = this.player.field_71071_by.func_70445_o();
            if (id == 10) {
                if (GuiNPCManageRecipes.func_175283_s()) {
                    GuiNPCManageRecipes.recipe.product.func_190920_e(1);
                } else if (GuiNPCManageRecipes.recipe.product.func_190926_b()) {
                    ItemStack stack = null;
                    if (GuiNPCManageRecipes.recipe.main) {
                        stack = heldStack.func_77946_l();
                    } else {
                        List<WrapperRecipe> groupList;
                        Map<String, List<WrapperRecipe>> globalMap = this.data.get(GuiNPCManageRecipes.recipe.global);
                        if (globalMap != null && (groupList = globalMap.get(GuiNPCManageRecipes.recipe.group)) != null) {
                            for (WrapperRecipe wr : groupList) {
                                if (!wr.main) continue;
                                stack = wr.product.func_77946_l();
                                break;
                            }
                        }
                    }
                    if (stack != null) {
                        stack.func_190920_e(1);
                        GuiNPCManageRecipes.recipe.product = stack;
                    }
                } else {
                    if (heldStack.func_190926_b()) {
                        GuiNPCManageRecipes.recipe.product.func_190920_e(Math.max(1, GuiNPCManageRecipes.recipe.product.func_190916_E() - 1));
                    } else if (!GuiNPCManageRecipes.recipe.main || NoppesUtilPlayer.compareItems(GuiNPCManageRecipes.recipe.product, heldStack, false, false)) {
                        GuiNPCManageRecipes.recipe.product.func_190920_e(Math.min(GuiNPCManageRecipes.recipe.product.func_77976_d(), GuiNPCManageRecipes.recipe.product.func_190916_E() + heldStack.func_190916_E()));
                    } else if (GuiNPCManageRecipes.recipe.main) {
                        GuiNPCManageRecipes.recipe.product = heldStack.func_77946_l();
                    }
                    button.setStacks(GuiNPCManageRecipes.recipe.product);
                }
                if (GuiNPCManageRecipes.recipe.product.func_190926_b()) {
                    button.setLayerColor(red);
                }
            } else {
                int pos = id - 11;
                ItemStack[] array = GuiNPCManageRecipes.recipe.recipeItems.get(pos);
                if (GuiNPCManageRecipes.func_146271_m()) {
                    if (heldStack.func_190926_b() || array.length >= 16) {
                        return;
                    }
                    if (array.length == 0) {
                        array = new ItemStack[]{heldStack.func_77946_l()};
                        array[0].func_190920_e(1);
                        button.setStacks(array);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    } else {
                        boolean found = false;
                        for (ItemStack stack : array) {
                            if (stack.func_190926_b() || !NoppesUtilPlayer.compareItems(stack, heldStack, false, false)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            array = Arrays.copyOf(array, array.length + 1);
                            array[array.length - 1] = heldStack.func_77946_l();
                            button.setStacks(array);
                            GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                        }
                    }
                } else if (GuiNPCManageRecipes.func_175283_s()) {
                    if (button.getCurrentStackID() < array.length) {
                        array[button.getCurrentStackID()].func_190920_e(1);
                        button.setStacks(array);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    } else if (array.length == 0 && !heldStack.func_190926_b()) {
                        array = new ItemStack[]{heldStack.func_77946_l()};
                        array[0].func_190920_e(1);
                        button.setStacks(array);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    }
                } else if (array == null || array.length == 0) {
                    if (!heldStack.func_190926_b()) {
                        array = new ItemStack[]{heldStack.func_77946_l()};
                        button.setStacks(array);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    }
                } else {
                    if (heldStack.func_190926_b()) {
                        int p = button.getCurrentStackID();
                        int count = Math.max(0, array[p].func_190916_E() - 1);
                        if (count > 0) {
                            array[p].func_190920_e(count);
                        } else {
                            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                            for (int i = 0; i < array.length; ++i) {
                                if (i == p) continue;
                                list.add(array[i]);
                            }
                            array = list.toArray(new ItemStack[0]);
                        }
                        button.setStacks(array);
                        button.setCurrentStackPos(p);
                        GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                    } else {
                        boolean found = false;
                        for (int i = 0; i < array.length; ++i) {
                            if (array[i].func_190926_b() || !NoppesUtilPlayer.compareItems(array[i], heldStack, false, false)) continue;
                            found = true;
                            array[i].func_190920_e(Math.min(array[i].func_77976_d(), array[i].func_190916_E() + heldStack.func_190916_E()));
                            button.setStacks(array);
                            button.setCurrentStackPos(i);
                            break;
                        }
                        if (!found) {
                            array[button.getCurrentStackID()] = heldStack.func_77946_l();
                            button.setStacks(array);
                            button.setCurrentStackPos(button.getCurrentStackID());
                        }
                    }
                    GuiNPCManageRecipes.recipe.recipeItems.put(pos, array);
                }
                if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                    button.setLayerColor(recipe.isValid() ? (array != null && array.length > 0 ? 0 : green) : red);
                }
            }
            return;
        }
        switch (id) {
            case 0: {
                this.save();
                recipe.clear();
                GuiNPCManageRecipes.recipe.global = button.getValue() == 0;
                this.func_73866_w_();
                break;
            }
            case 1: {
                SubGuiEditText subGui = new SubGuiEditText(0, new String[]{Util.instance.getResourceName(GuiNPCManageRecipes.recipe.group)});
                subGui.latinAlphabetOnly = true;
                subGui.allowUppercase = false;
                this.setSubGui(subGui);
                break;
            }
            case 2: {
                Client.sendData(EnumPacketServer.RecipeRemoveGroup, GuiNPCManageRecipes.recipe.global, GuiNPCManageRecipes.recipe.group);
                recipe.clear();
                this.wait = true;
                break;
            }
            case 3: {
                String[] hovers;
                String label;
                String[] text;
                int i;
                if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                    i = 1;
                    text = new String[]{Util.instance.getResourceName(GuiNPCManageRecipes.recipe.name)};
                    label = new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + ":";
                    hovers = new String[]{new TextComponentTranslation("recipe.hover.recipe.named", new Object[0]).func_150254_d() + ". " + new TextComponentTranslation("hover.latin.alphabet.only", new Object[0]).func_150254_d()};
                } else {
                    i = 4;
                    text = new String[]{GuiNPCManageRecipes.recipe.group, GuiNPCManageRecipes.recipe.name};
                    label = new TextComponentTranslation("gui.group", new Object[0]).func_150254_d() + " / " + new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + ":";
                    hovers = new String[]{new TextComponentTranslation("recipe.hover.group.named", new Object[0]).func_150254_d() + ". " + new TextComponentTranslation("hover.latin.alphabet.only", new Object[0]).func_150254_d(), new TextComponentTranslation("recipe.hover.recipe.named", new Object[0]).func_150254_d() + ". " + new TextComponentTranslation("hover.latin.alphabet.only", new Object[0]).func_150254_d()};
                }
                SubGuiEditText subGui = new SubGuiEditText(i, text);
                subGui.label = label;
                subGui.hovers = hovers;
                subGui.latinAlphabetOnly = true;
                subGui.allowUppercase = false;
                this.setSubGui(subGui);
                break;
            }
            case 4: {
                Client.sendData(EnumPacketServer.RecipeRemove, GuiNPCManageRecipes.recipe.global, GuiNPCManageRecipes.recipe.group, GuiNPCManageRecipes.recipe.name);
                GuiNPCManageRecipes.recipe.name = "";
                this.wait = true;
                break;
            }
            case 5: {
                GuiNPCManageRecipes.recipe.ignoreDamage = !GuiNPCManageRecipes.recipe.ignoreDamage;
                this.save();
                this.func_73866_w_();
                break;
            }
            case 6: {
                GuiNPCManageRecipes.recipe.ignoreNBT = !GuiNPCManageRecipes.recipe.ignoreNBT;
                this.save();
                this.func_73866_w_();
                break;
            }
            case 7: {
                GuiNPCManageRecipes.recipe.known = !GuiNPCManageRecipes.recipe.known;
                this.save();
                this.func_73866_w_();
                break;
            }
            case 8: {
                this.setSubGui(new SubGuiNpcAvailability(GuiNPCManageRecipes.recipe.availability, (GuiScreen)this));
                break;
            }
            case 9: {
                GuiNPCManageRecipes.recipe.isShaped = !GuiNPCManageRecipes.recipe.isShaped;
                this.save();
                break;
            }
            case 28: {
                ItemStack heldStack = this.player.field_71071_by.func_70445_o();
                if (heldStack.func_190926_b()) break;
                this.player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                Client.sendData(EnumPacketServer.SetItem, ItemStack.field_190927_a.func_77955_b(new NBTTagCompound()));
                break;
            }
            case 30: {
                onlyMod = ((GuiNpcCheckBox)button).isSelected();
                this.func_73866_w_();
                break;
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.wait) {
            this.drawWait();
            return;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.subgui != null || !CustomNpcs.ShowDescriptions) {
            return;
        }
        for (int i = 11; i < 27; ++i) {
            if (this.getButton(i) == null || !this.getButton(i).isVisible() || !this.getButton(i).isHovered() || this.getButton(i).getCurrentStack().func_190926_b()) continue;
            TextComponentTranslation hover = new TextComponentTranslation("recipe.hover.ingredients", new Object[]{"" + (i - 11)});
            if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.0", new Object[0]));
                hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.1", new Object[0]));
                hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.2", new Object[0]));
            }
            hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.3", new Object[0]));
            if (this.getButton(i).getCurrentStack() != null) {
                hover.func_150257_a((ITextComponent)new TextComponentString("<br>"));
                List list = this.getButton(i).getCurrentStack().func_82840_a((EntityPlayer)this.player, (ITooltipFlag)(this.player.field_71075_bZ.field_75098_d ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                for (String str : list) {
                    hover.func_150257_a((ITextComponent)new TextComponentString("<br>" + str));
                }
            }
            this.drawHoverText(hover.func_150254_d(), new Object[0]);
            break;
        }
    }

    @Override
    public void func_73866_w_() {
        int id;
        super.func_73866_w_();
        this.wait = false;
        this.data.clear();
        if (onlyMod && !GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
            recipe.clear();
        }
        for (Object loc : CraftingManager.field_193380_a.func_148742_b()) {
            IRecipe r = (IRecipe)CraftingManager.field_193380_a.func_82594_a(loc);
            if (!(r instanceof INpcRecipe) && !(r instanceof IShapedRecipe) && !(r instanceof ShapelessRecipes) || onlyMod && !(r instanceof INpcRecipe)) continue;
            WrapperRecipe wrapper = new WrapperRecipe();
            wrapper.copyFrom(r, CraftingManager.field_193380_a.func_148757_b((Object)r));
            if (!this.data.containsKey(wrapper.global)) {
                this.data.put(wrapper.global, new TreeMap());
            }
            if (!this.data.get(wrapper.global).containsKey(wrapper.group)) {
                this.data.get(wrapper.global).put(wrapper.group, new ArrayList());
            }
            this.data.get(wrapper.global).get(wrapper.group).add(wrapper);
        }
        this.data.forEach((k0, v0) -> v0.forEach((k1, v1) -> v1.sort(Comparator.comparing(WrapperRecipe::getName))));
        if (GuiNPCManageRecipes.recipe.group.isEmpty() && !this.data.get(GuiNPCManageRecipes.recipe.global).isEmpty()) {
            recipe.clear();
            GuiNPCManageRecipes.recipe.group = this.data.get((Object)Boolean.valueOf((boolean)GuiNPCManageRecipes.recipe.global)).values().iterator().next().get((int)0).group;
        }
        if (!GuiNPCManageRecipes.recipe.name.isEmpty()) {
            boolean found = false;
            if (this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(GuiNPCManageRecipes.recipe.group) && !this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group).isEmpty()) {
                for (WrapperRecipe wr : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                    if (!wr.name.equals(GuiNPCManageRecipes.recipe.name)) continue;
                    found = true;
                    recipe.copyFrom(wr);
                    break;
                }
            }
            if (!found) {
                GuiNPCManageRecipes.recipe.name = "";
            }
        }
        if (GuiNPCManageRecipes.recipe.name.isEmpty() && this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(GuiNPCManageRecipes.recipe.group) && !this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group).isEmpty()) {
            recipe.copyFrom(this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group).get(0));
        }
        GuiNpcLabel label = new GuiNpcLabel(0, "gui.recipe.groups", this.field_147003_i + 172, this.field_147009_r + 8);
        label.setHoverText("recipe.hover.info.groups", new Object[0]);
        this.addLabel(label);
        label = new GuiNpcLabel(1, "gui.recipe.crafts", this.field_147003_i + 294, this.field_147009_r + 8);
        label.setHoverText("recipe.hover.info.crafts", new Object[0]);
        this.addLabel(label);
        if (this.groups == null) {
            this.groups = new GuiCustomScroll(this, 0);
        }
        if (this.recipes == null) {
            this.recipes = new GuiCustomScroll(this, 1);
        }
        ArrayList<String> recipesList = new ArrayList<String>();
        ArrayList<String> groupsList = new ArrayList<String>(this.data.get(GuiNPCManageRecipes.recipe.global).keySet());
        LinkedHashMap<Integer, List<String>> htsG = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String string : groupsList) {
            String domen = "customnpcs";
            String name = "Empty";
            if (!this.data.get(GuiNPCManageRecipes.recipe.global).get(string).isEmpty()) {
                domen = this.data.get((Object)Boolean.valueOf((boolean)GuiNPCManageRecipes.recipe.global)).get((Object)string).get((int)0).domen;
                ItemStack stack = this.data.get((Object)Boolean.valueOf((boolean)GuiNPCManageRecipes.recipe.global)).get((Object)string).get((int)0).product;
                name = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString() + '\u00a7' + "7; count: " + '\u00a7' + "6" + stack.func_190916_E() + '\u00a7' + "7; meta: " + '\u00a7' + "e" + stack.func_77952_i();
                if (stack.func_77942_o()) {
                    name = name + "\u00a77; (\u00a7dhas NBT\u00a77)";
                }
            }
            ArrayList<String> ht = new ArrayList<String>();
            ht.add("\u00a77Group: \u00a7f" + Util.instance.deleteColor(string));
            ht.add("\u00a77Item: \u00a7f" + name);
            ht.add("\u00a77Mod: \u00a7b" + domen);
            ht.add("\u00a77Is global group: \u00a7" + (GuiNPCManageRecipes.recipe.global ? "atrue" : "dfalse"));
            htsG.put(i++, ht);
        }
        LinkedHashMap<Integer, List<String>> htsR = new LinkedHashMap<Integer, List<String>>();
        if (this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(GuiNPCManageRecipes.recipe.group)) {
            for (WrapperRecipe wrapper : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                recipesList.add(wrapper.name);
                ArrayList<String> ht = new ArrayList<String>();
                ht.add("\u00a77Group: \u00a7f" + Util.instance.deleteColor(wrapper.group));
                ht.add("\u00a77Name: \u00a7f" + Util.instance.deleteColor(wrapper.name));
                ht.add("\u00a77ID: \u00a76" + wrapper.id);
                ht.add("\u00a77Mod: \u00a7b" + wrapper.domen);
                ht.add("\u00a77Is main product: \u00a7" + (wrapper.main ? "atrue" : "dfalse"));
                ht.add("\u00a77Is global recipe: \u00a7" + (wrapper.global ? "atrue" : "dfalse"));
                ht.add("\u00a77Is shaped: \u00a7" + (wrapper.isShaped ? "atrue" : "dfalse"));
                ht.add("\u00a77Always known: \u00a7" + (wrapper.known ? "atrue" : "dfalse"));
                htsR.put(i++, ht);
            }
        }
        this.groups.setListNotSorted(groupsList);
        this.groups.setHoverTexts(htsG);
        this.groups.setSize(120, 168);
        this.groups.guiLeft = this.field_147003_i + 172;
        this.groups.guiTop = this.field_147009_r + 20;
        this.addScroll(this.groups);
        if (!GuiNPCManageRecipes.recipe.group.isEmpty()) {
            this.groups.setSelected(GuiNPCManageRecipes.recipe.group);
        }
        this.recipes.setListNotSorted(recipesList);
        this.recipes.setHoverTexts(htsR);
        this.recipes.setSize(120, 168);
        this.recipes.guiLeft = this.field_147003_i + 294;
        this.recipes.guiTop = this.field_147009_r + 20;
        this.addScroll(this.recipes);
        if (!GuiNPCManageRecipes.recipe.name.isEmpty()) {
            this.recipes.setSelected(GuiNPCManageRecipes.recipe.name);
        }
        int n = this.field_147003_i + 118;
        int y = this.field_147009_r + 191;
        boolean hasItem = recipe.isValid() && GuiNPCManageRecipes.recipe.domen.equals("customnpcs");
        GuiNpcButton button = new GuiButtonBiDirectional(0, this.field_147003_i + 6, y, 163, 20, new String[]{"menu.global", "tile.npccarpentybench.name"}, GuiNPCManageRecipes.recipe.global ? 0 : 1);
        button.layerColor = GuiNPCManageRecipes.recipe.global ? new Color(0x4000FF00).getRGB() : new Color(0x400000FF).getRGB();
        button.setHoverText("recipe.hover.type", new Object[0]);
        this.addButton(button);
        if (GuiNPCManageRecipes.recipe.global) {
            this.addButton(new GuiNpcCheckBox(30, this.field_147003_i + 7, this.field_147009_r + 97, 95, 12, "gui.recipe.type.true", "gui.recipe.type.false", onlyMod));
        }
        button = new GuiNpcButton(1, this.field_147003_i + 172, y, 59, 20, "gui.add");
        button.setHoverText("recipe.hover.add.group", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.field_147003_i + 234, y, 59, 20, "gui.remove");
        button.setEnabled(this.groups.hasSelected() && GuiNPCManageRecipes.recipe.domen.equals("customnpcs"));
        button.setHoverText("recipe.hover.del.group", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.field_147003_i + 294, y, 59, 20, "gui.copy");
        button.setEnabled(!GuiNPCManageRecipes.recipe.domen.equals("customnpcs") || this.recipes.getList().size() < 16);
        button.setHoverText("recipe.hover.add.recipe", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, this.field_147003_i + 356, y, 59, 20, "gui.remove");
        button.setEnabled(this.recipes.hasSelected() && GuiNPCManageRecipes.recipe.domen.equals("customnpcs"));
        button.setHoverText("recipe.hover.del.recipe", new Object[0]);
        this.addButton(button);
        if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
            y = this.field_147009_r + 4;
            this.addLabel(new GuiNpcLabel(2, "availability.options", this.field_147003_i + 6, y + 5));
            button = new GuiNpcButton(8, n, y, 50, 20, "selectServer.edit");
            button.setEnabled(hasItem);
            button.setHoverText("availability.hover", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(9, n, y += 21, 50, 20, new String[]{"gui.shaped.0", "gui.shaped.1"}, GuiNPCManageRecipes.recipe.isShaped ? 1 : 0);
            button.setEnabled(hasItem);
            button.layerColor = hasItem ? (GuiNPCManageRecipes.recipe.isShaped ? green : new Color(-9408257).getRGB()) : new Color(0).getRGB();
            button.setHoverText("recipe.hover.shared", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(7, n, y += 21, 50, 20, new String[]{"gui.known.0", "gui.known.1"}, GuiNPCManageRecipes.recipe.known ? 1 : 0);
            button.setEnabled(hasItem);
            button.layerColor = hasItem ? (GuiNPCManageRecipes.recipe.known ? green : red) : 0;
            button.setHoverText("recipe.hover.known", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(5, n, y += 21, 50, 20, new String[]{"gui.ignoreDamage.0", "gui.ignoreDamage.1"}, GuiNPCManageRecipes.recipe.ignoreDamage ? 0 : 1);
            button.layerColor = hasItem ? (GuiNPCManageRecipes.recipe.ignoreDamage ? green : red) : 0;
            button.setHoverText("recipe.hover.damage", new Object[0]);
            this.addButton(button);
            button = new GuiNpcButton(6, n, y + 21, 50, 20, new String[]{"gui.ignoreNBT.0", "gui.ignoreNBT.1"}, GuiNPCManageRecipes.recipe.ignoreNBT ? 0 : 1);
            button.layerColor = hasItem ? (GuiNPCManageRecipes.recipe.ignoreNBT ? green : red) : 0;
            button.setHoverText("recipe.hover.nbt", new Object[0]);
            this.addButton(button);
        }
        int craftOffset = GuiNPCManageRecipes.recipe.global ? 9 : 0;
        button = new GuiNpcButton(10, this.field_147003_i + 7 + craftOffset + (GuiNPCManageRecipes.recipe.global ? 61 : 76), this.field_147009_r + 14 + craftOffset + (int)((GuiNPCManageRecipes.recipe.global ? 1.0 : 1.5) * 19.0), 30, 30, "");
        button.texture = GuiNPCInterface.ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 220;
        button.txrY = 96;
        button.txrW = 36;
        button.txrH = 36;
        if (GuiNPCManageRecipes.recipe.product.func_190926_b()) {
            button.layerColor = red;
        }
        button.setEnabled(GuiNPCManageRecipes.recipe.domen.equals("customnpcs") && recipe.isValid());
        if (!GuiNPCManageRecipes.recipe.main) {
            button.layerColor = new Color(-6250336).getRGB();
        }
        button.setStacks(GuiNPCManageRecipes.recipe.product);
        TextComponentTranslation hover = new TextComponentTranslation("recipe.hover.product", new Object[0]);
        if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
            if (!GuiNPCManageRecipes.recipe.main) {
                hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.4", new Object[0]));
            }
            hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.1", new Object[0]));
            hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.2", new Object[0]));
        }
        hover.func_150257_a((ITextComponent)new TextComponentTranslation("recipe.hover.ingredient.3", new Object[0]));
        if (GuiNPCManageRecipes.recipe.product != null) {
            hover.func_150257_a((ITextComponent)new TextComponentString("<br>"));
            List list = GuiNPCManageRecipes.recipe.product.func_82840_a((EntityPlayer)this.player, (ITooltipFlag)(this.player.field_71075_bZ.field_75098_d ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            for (String str : list) {
                hover.func_150257_a((ITextComponent)new TextComponentString("<br>" + str));
            }
        }
        button.setHoverText(hover.func_150254_d(), new Object[0]);
        this.addButton(button);
        int s = GuiNPCManageRecipes.recipe.global ? 3 : 4;
        for (int h = 0; h < s; ++h) {
            for (int w = 0; w < s; ++w) {
                id = 11 + w + h * s;
                button = new GuiNpcButton(id, this.field_147003_i + craftOffset + w * 19 + 7, this.field_147009_r + craftOffset + h * 19 + 20, 18, 18, "");
                button.texture = GuiNPCInterface.ANIMATION_BUTTONS;
                button.hasDefBack = false;
                button.isAnim = true;
                button.txrX = 220;
                button.txrY = 96;
                button.txrW = 36;
                button.txrH = 36;
                button.setEnabled(GuiNPCManageRecipes.recipe.domen.equals("customnpcs") && recipe.isValid());
                if (GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) {
                    button.layerColor = recipe.isValid() ? green : red;
                }
                this.addButton(button);
            }
        }
        for (int w = 0; w < GuiNPCManageRecipes.recipe.width; ++w) {
            for (int h = 0; h < GuiNPCManageRecipes.recipe.height; ++h) {
                id = 11 + h * GuiNPCManageRecipes.recipe.height + w;
                int slotID = h * GuiNPCManageRecipes.recipe.width + w;
                ItemStack[] stacks = GuiNPCManageRecipes.recipe.recipeItems.get(slotID);
                button = (GuiNpcButton)this.getButton(id);
                button.setStacks(stacks);
                if (!GuiNPCManageRecipes.recipe.domen.equals("customnpcs")) continue;
                button.layerColor = recipe.isValid() ? (stacks != null && stacks.length > 0 ? 0 : green) : red;
            }
        }
        button = new GuiNpcButton(28, this.field_147003_i + 92, this.field_147009_r + 77, 18, 18, "");
        button.texture = GuiNPCInterface.ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 120;
        button.txrW = 24;
        button.txrH = 24;
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        if (!(recipe.isValid() && GuiNPCManageRecipes.recipe.parent instanceof INpcRecipe && GuiNPCManageRecipes.recipe.domen.equals("customnpcs"))) {
            return;
        }
        Client.sendData(EnumPacketServer.RecipeSave, recipe.getNbt());
        this.wait = true;
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            if (GuiNPCManageRecipes.recipe.group.equals(this.groups.getSelected()) && !this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(this.groups.getSelected())) {
                return;
            }
            this.save();
            recipe.clear();
            GuiNPCManageRecipes.recipe.group = this.groups.getSelected();
        } else {
            if (GuiNPCManageRecipes.recipe.name.equals(this.recipes.getSelected()) && !this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(GuiNPCManageRecipes.recipe.group)) {
                return;
            }
            for (WrapperRecipe wrapper : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                if (!wrapper.name.equals(this.recipes.getSelected())) continue;
                this.save();
                recipe.copyFrom(wrapper);
                break;
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        switch (scroll.getID()) {
            case 0: {
                this.setSubGui(new SubGuiEditText(2, new String[]{selection}));
                break;
            }
            case 1: {
                this.setSubGui(new SubGuiEditText(3, new String[]{selection}));
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiNpcAvailability) {
            this.save();
        } else if (subgui instanceof SubGuiEditIngredients) {
            ItemStack[] stacks = new ItemStack[]{};
            if (((SubGuiEditIngredients)subgui).stacks != null) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (ItemStack stack : ((SubGuiEditIngredients)subgui).stacks) {
                    if (stack.func_190926_b()) continue;
                    list.add(stack);
                }
                if (!list.isEmpty()) {
                    stacks = list.toArray(stacks);
                }
            }
            if (this.getButton(11 + subgui.getId()) != null) {
                GuiNpcButton button = (GuiNpcButton)this.getButton(11 + subgui.getId());
                button.setStacks(stacks);
                button.setCurrentStackPos(0);
                if (stacks.length == 0) {
                    button.layerColor = recipe.isValid() ? new Color(-9375632).getRGB() : new Color(-1019792).getRGB();
                }
            }
            GuiNPCManageRecipes.recipe.recipeItems.put(subgui.getId(), stacks);
        } else if (subgui instanceof SubGuiEditText) {
            if (((SubGuiEditText)subgui).cancelled) {
                return;
            }
            if (subgui.getId() == 0) {
                this.save();
                recipe.clear();
                GuiNPCManageRecipes.recipe.group = Util.instance.getResourceName(((SubGuiEditText)subgui).text[0]);
                GuiNPCManageRecipes.recipe.name = "default";
                Client.sendData(EnumPacketServer.RecipesAddGroup, GuiNPCManageRecipes.recipe.global, GuiNPCManageRecipes.recipe.group);
            } else if (subgui.getId() == 1) {
                boolean found;
                this.save();
                String name = ((SubGuiEditText)subgui).text[0];
                block1: do {
                    found = false;
                    for (WrapperRecipe wr : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                        if (!wr.name.equals(name)) continue;
                        name = name + "_";
                        found = true;
                        continue block1;
                    }
                } while (found);
                GuiNPCManageRecipes.recipe.name = name;
                Client.sendData(EnumPacketServer.RecipeAdd, recipe.getNbt());
            } else if (subgui.getId() == 2) {
                String old = GuiNPCManageRecipes.recipe.group;
                GuiNPCManageRecipes.recipe.group = Util.instance.getResourceName(((SubGuiEditText)subgui).text[0]);
                Client.sendData(EnumPacketServer.RecipesRenameGroup, GuiNPCManageRecipes.recipe.global, old, GuiNPCManageRecipes.recipe.group);
            } else if (subgui.getId() == 3) {
                String old = GuiNPCManageRecipes.recipe.name;
                GuiNPCManageRecipes.recipe.name = Util.instance.getResourceName(((SubGuiEditText)subgui).text[0]);
                Client.sendData(EnumPacketServer.RecipesRename, GuiNPCManageRecipes.recipe.global, old, GuiNPCManageRecipes.recipe.group, GuiNPCManageRecipes.recipe.name);
            } else if (subgui.getId() == 4) {
                String group = ((SubGuiEditText)subgui).text[0];
                if (this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(group) && this.data.get(GuiNPCManageRecipes.recipe.global).get(group).size() >= 16) {
                    return;
                }
                GuiNPCManageRecipes.recipe.group = Util.instance.getResourceName(group);
                String name = Util.instance.getResourceName(((SubGuiEditText)subgui).text[1]);
                while (this.data.get(GuiNPCManageRecipes.recipe.global).containsKey(GuiNPCManageRecipes.recipe.group)) {
                    boolean found = false;
                    for (WrapperRecipe wr : this.data.get(GuiNPCManageRecipes.recipe.global).get(GuiNPCManageRecipes.recipe.group)) {
                        if (!wr.name.equals(name)) continue;
                        name = name + "_";
                        found = true;
                        break;
                    }
                    if (found) continue;
                    break;
                }
                GuiNPCManageRecipes.recipe.name = name;
                Client.sendData(EnumPacketServer.RecipeAdd, recipe.getNbt());
            } else {
                return;
            }
            this.wait = true;
        }
    }
}

